/*
 * Decompiled with CFR 0.152.
 */
package com.coupon.service;

import com.utility.ConvertStr;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.http.HttpEntity;
import org.springframework.http.HttpHeaders;
import org.springframework.http.HttpMethod;
import org.springframework.http.HttpStatus;
import org.springframework.http.ResponseEntity;
import org.springframework.stereotype.Service;
import org.springframework.util.MultiValueMap;
import org.springframework.web.client.HttpStatusCodeException;
import org.springframework.web.client.RestClientException;
import org.springframework.web.client.RestTemplate;

@Service
public class CouponService {
    private static final Logger log = LoggerFactory.getLogger(CouponService.class);
    private final RestTemplate restTemplate;
    private final Class<Object> aClass = Object.class;

    public CouponService(RestTemplate restTemplate) {
        this.restTemplate = restTemplate;
    }

    public Object postToAPI(Object body, String urlEndPoint, String jwtToken) throws RestClientException {
        String baseUrl = "https://kalabarg.sfara.ir/";
        String url = baseUrl + urlEndPoint;
        HttpEntity entity = this.makeRequestEntity(body, jwtToken);
        try {
            ResponseEntity response = this.restTemplate.exchange(url, HttpMethod.POST, entity, this.aClass, new Object[0]);
            return response.getBody();
        }
        catch (HttpStatusCodeException e) {
            return ((ResponseEntity.BodyBuilder)ResponseEntity.status((HttpStatus)e.getStatusCode()).headers(e.getResponseHeaders())).body((Object)e.getResponseBodyAsString());
        }
    }

    private HttpEntity<Object> makeRequestEntity(Object body, String jwtToken) {
        HttpHeaders headers = new HttpHeaders();
        if (!ConvertStr.isNullOrEmpty((String)jwtToken)) {
            headers.add("Authorization", jwtToken);
        }
        headers.add("Content-Type", "application/json");
        return new HttpEntity(body, (MultiValueMap)headers);
    }
}

